import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class ContentLimitsSection extends StatefulWidget {
  const ContentLimitsSection({Key? key}) : super(key: key);

  @override
  _ContentLimitsSectionState createState() => _ContentLimitsSectionState();
}

class _ContentLimitsSectionState extends State<ContentLimitsSection> with AppActiveContentMixin {
  @override
  build(context) {
    return FormEditorPage(
      heading: 'Content Upload Limits',
      description: 'You can limit the amount of media your end users can upload on your site.',
      items: [
        SettingItem(
          intId: AppSettings.ID_SETTING_MAX_USER_DISPLAY_IMAGE_FILE_SIZE,
          settingKey: AppSettings.KEY_SETTING_MAX_USER_DISPLAY_IMAGE_FILE_SIZE,
          type: FieldType.text,
          leading: 'Maximum Size for User Display Image',
          placeholder: 'e.g 2',
          description: "Images over the maximum size will be rejected on upload. (in MegaBytes)",
        ),
        SettingItem(
          intId: AppSettings.ID_SETTING_MAX_POST_DISPLAY_CONTENT_ITEM_FILE_SIZE,
          settingKey: AppSettings.KEY_SETTING_MAX_POST_DISPLAY_CONTENT_ITEM_FILE_SIZE,
          type: FieldType.text,
          leading: 'Maximum Size for Post Display Image',
          placeholder: 'e.g 2',
          description: "Images over the maximum size will be rejected on upload. (in MegaBytes)",
        ),
        SettingItem(
          intId: AppSettings.ID_SETTING_MAX_POST_DISPLAY_CONTENT_ITEM,
          settingKey: AppSettings.KEY_SETTING_MAX_POST_DISPLAY_CONTENT_ITEM,
          type: FieldType.text,
          leading: 'Maximum number of allowed images in a single Post',
          placeholder: 'e.g 10',
        ),
        SettingItem(
          intId: AppSettings.ID_SETTING_MIN_POST_DISPLAY_CONTENT_ITEM,
          settingKey: AppSettings.KEY_SETTING_MIN_POST_DISPLAY_CONTENT_ITEM,
          type: FieldType.text,
          leading: 'Minimum number of allowed images in a single Post',
          placeholder: 'e.g 1',
        ),
      ],
    );
  }
}
